/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

$(document).on('change','#employee_registration_id', function() {
    var $employee_registration_id = $('#employee_registration_id option:selected').val();
    var $data = $('#employee_registration_id option:selected').data();
    $('#company_id').val($data['company_id']);
    $('#registration_code').val($data['registration_code']);
    $('#tblSpecialAllowance tbody').html('');

    $.ajax({
        url: $URLGetPolicy,
        dataType: 'json',
        type: 'post',
        data: 'company_id='+$data['company_id']+'&employee_registration_id='+$employee_registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#employee_registration_id').before('<i id="loader" class="fa fa-spinner fa-spin"></i>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#tblPolicy tbody').html(json.html_policy);
                $('#tblApproved tbody').html(json.html_approved);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
});

$(document).on('click', '.btnAddAllowance', function() {
    var $employee_registration_id = $('#employee_registration_id option:selected').val();
    if($family_exists==0) {
        alert('Please add Family Members in your Profile');
    }
    if($employee_registration_id!='' && $family_exists==1) {
        var $html = '';
        $html += '<tr id="grid_row_id_'+$grid_row_allowance+'" data-row_id="'+$grid_row_allowance+'">';
        $html += '<td style="width: 15px;"><a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>';
        $html += '<td>';
        $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_allowance_for" name="details['+$grid_row_allowance+'][allowance_for]" value="" />';
        $html += '<select onchange="updateRelation('+$grid_row_allowance+');" class="form-control" id="detail_'+$grid_row_allowance+'_employee_family_id" name="details['+$grid_row_allowance+'][employee_family_id]" >';
        $.each($families,function($i,$family) {
            $html += '<option data-relation="'+$family['relation']+'" value="'+$family['employee_family_id']+'">'+$family['full_name']+'</option>';
        })
        $html += '</select>';
        $html += '</td>';
        $html += '<td><input onchange="calculateTotal();" type="text" class="form-control fPDecimal" id="detail_'+$grid_row_allowance+'_amount" name="details['+$grid_row_allowance+'][amount]" value="" /></td>';
        $html += '<td><input type="text" class="form-control " id="detail_'+$grid_row_allowance+'_remarks" name="details['+$grid_row_allowance+'][remarks]" value="" /></td>';
        $html += '<td><input type="text" class="form-control dtpDate" id="detail_'+$grid_row_allowance+'_receipt_date" name="details['+$grid_row_allowance+'][receipt_date]" value="" /></td>';
        $html += '<td><input type="text" class="form-control" id="detail_'+$grid_row_allowance+'_receipt_no" name="details['+$grid_row_allowance+'][receipt_no]" value="" /></td>';
        $html += '</tr>';

        $('#tblSpecialAllowance tbody').append($html);
        $('#detail_'+$grid_row_allowance+'_employee_family_id').trigger('change');
        $grid_row_allowance++;
        setFieldFormat();
    }
});

function updateRelation($allowance_id) {
    var $relation = $('#detail_'+$allowance_id+'_employee_family_id option:selected').data('relation');
    $('#detail_'+$allowance_id+'_allowance_for').val($relation);
}

$(document).on('click','.btnRemoveAllowance',function() {
    var $row_id = $(this).parent().parent().data('row_id');
    $('#grid_row_id_'+$row_id).remove();

    calculateTotal();
});

function calculateTotal() {

    var $total_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function(){
        var $row_id = $(this).data('row_id');
        var $amount = $('#detail_'+$row_id+'_amount').val() | 0;

        $total_amount += parseFloat($amount);
    });
    /*console.log($total_amount);*/

    $('#total_amount').val($total_amount);
};
