/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('change','#company_account_id', function() {
    var $data = $('#company_account_id option:selected').data();
    var $bank_id = $data['bank_id'];
    var $bank_name = $data['bank_name'];
    var $bank_branch = $data['bank_branch'];

    $('#bank_id').val($bank_id);
    $('#bank_name').val($bank_name);
    $('#bank_branch').val($bank_branch);
})

$(document).on('click','#btnSearch', function() {
    var $payroll_date = $('#payroll_date').val();
    var $bank_id = $('#bank_id').val();
    var $employee_registration_id = $('#employee_registration_id').val();

    if(($bank_id != '' || $employee_registration_id !='') && $payroll_date != '') {
        $data = $('#form').serialize();
        $.ajax({
            url: $URLGetPayrolls,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tblDepositSlip tbody').html('');
                $('#cheque_amount').val('');
            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblDepositSlip tbody').html(json.html);
                    $('#cheque_amount').val(json.total_amount);
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        });
    } else {
        $('#tblDepositSlip tbody').html('');
    }
})

function calculateAmount() {
    var $total_amount = 0;
    $('#tblDepositSlip tbody tr input').each(function() {
        if($(this).is(':checked')) {
            $total_amount += parseFloat($(this).data('amount'));
        }
    })

    $('#cheque_amount').val($total_amount);
}