/**
 * Created by Huzaifa on 9/18/15.
 */

var $payrolls;

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnCalculate', function() {
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLGetPayroll,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tblPayroll tbody').html('');
                $('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
            },
            complete: function() {
                $('#btnCalculate').html('Calculate');
            },
            success: function(json) {
                if(json.success)
                {
//                    console.log(json);
                    $('#tblPayroll tbody').html(json.html);
                    $payrolls = json.payrolls;
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
})

function calculatePayable($id) {
    var $gross_salary = $('#payroll_'+$id+'_gross_salary').val();
    var $tax_deduction = $('#payroll_'+$id+'_tax_deduction').val();
    var $other_deduction = $('#payroll_'+$id+'_other_deduction').val();
    var $net_salary = $gross_salary-$tax_deduction-$other_deduction;
    var $total_present = $('#payroll_'+$id+'_total_present').val();
    var $working_days = $('#payroll_'+$id+'_working_days').val();
    var $payable_salary = ($net_salary/$working_days*$total_present).toFixed(0);

    $('#payroll_'+$id+'_net_salary').val($net_salary);
    $('#payroll_'+$id+'_payable_salary').val($payable_salary);

    calculateTotal();
}

function getTaxDescription($obj) {
    var $registration_id = $($obj).parent().parent().parent().parent().data('registration_id');
    var $taxDescriptions = $payrolls[$registration_id]['tax_description'];
    if (typeof $taxDescriptions !== 'undefined' && $taxDescriptions.length > 0) {
        // the array is defined and has at least one element
        $html = '';
        $html += '<table id="taxDescription" class="table table-striped">';
        $($taxDescriptions).each(function($i, $value) {
            var $amount = parseFloat($value['amount']);
            $html += '  <tr>';
            if($value['break']) {
                $html += '      <td class="text-left" style="border-top: 1px solid black;">'+$value['description']+'</td>';
                $html += '      <td class="text-right" style="border-top: 1px solid black;">'+$amount+'</td>';
            } else {
                $html += '      <td class="text-left">'+$value['description']+'</td>';
                $html += '      <td class="text-right">'+$amount+'</td>';
            }
            $html += '  </tr>';
        });
        $html += '</table>';

        var dialog = bootbox.dialog({
            message: $html,
            backdrop: true
        });
    }
}

function calculateTotal() {
    var $total_house_rent_allowance=0;
    var $total_basic_salary=0;
    var $total_other_allowance=0;
    var $total_arrears=0;
    var $total_gross_salary=0;
    var $total_tax_deduction=0;
    var $total_other_deduction=0;
    var $total_net_salary=0;
    var $total_payable_salary=0;
    $('#tblPayroll tbody tr').each(function() {
        var $id = $(this).data('id');
        if(typeof $id !='undefined') {
            var $checked = $('#payroll_'+$id+'_selected').is(':checked');
            if($checked) {
                $total_house_rent_allowance += parseFloat($('#payroll_'+$id+'_house_rent_allowance').val() | 0);
                $total_basic_salary += parseFloat($('#payroll_'+$id+'_basic_salary').val() | 0);
                $total_other_allowance += parseFloat($('#payroll_'+$id+'_other_allowance').val() | 0);
                $total_arrears += parseFloat($('#payroll_'+$id+'_arrears').val() | 0);
                $total_gross_salary += parseFloat($('#payroll_'+$id+'_gross_salary').val() | 0);
                $total_tax_deduction += parseFloat($('#payroll_'+$id+'_tax_deduction').val() | 0);
                $total_other_deduction += parseFloat($('#payroll_'+$id+'_other_deduction').val() | 0);
                $total_net_salary += parseFloat($('#payroll_'+$id+'_net_salary').val() | 0);
                $total_payable_salary += parseFloat($('#payroll_'+$id+'_payable_salary').val() | 0);
            }
        }
    });

    $('#total_sa').text($total_house_rent_allowance + $total_gross_salary);
    $('#total_basic_salary').text($total_basic_salary);
    $('#total_other_allowance').text($total_other_allowance);
    $('#total_arrears').text($total_arrears);
    $('#total_gross_salary').text($total_gross_salary);
    $('#total_tax_deduction').text($total_tax_deduction);
    $('#total_other_deduction').text($total_other_deduction);
    $('#total_net_salary').text($total_net_salary);
    $('#total_payable_salary').text($total_payable_salary);
}

$(document).on('click','input[type=checkbox]',function() {
    calculateTotal();
})