<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-3 profile">
                    <div class="box box-primary">
                        <div class="box-body box-profile">
                            <img style="width: 150px;" class="profile-user-img img-responsive img-circle" src="<?php echo $employee_image; ?>" alt="User profile picture">
                            <h3 class="profile-username text-center"><?php echo $full_name; ?></h3>
                            <p class="text-muted text-center"><?php echo $qualification; ?></p>

                            <ul class="list-group list-group-unbordered">
                                <li class="list-group-item">
                                    <b>Birth Date:</b> <a class="pull-right"><?php echo $dob; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Gender:</b> <a class="pull-right"><?php echo $gender; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Mobile No:</b> <a class="pull-right"><?php echo $mobile_no; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Email:</b> <a class="pull-right"><?php echo $email; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>CNIC No:</b> <a class="pull-right"><?php echo $cnic_no; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>EOBI No:</b> <a class="pull-right"><?php echo $eobi_no; ?></a>
                                </li>
                            </ul>

                            <a href="<?php echo $href_employee_profile; ?>" class="btn btn-primary btn-block"><b>Edit Profile</b></a>
                        </div><!-- /.box-body -->
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Payroll</h3>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <?php foreach($payrolls as $payroll): ?>
                                <div class="col-sm-4">
                                    <div class="box box-success box-solid">
                                        <div class="box-header with-border">
                                            <h3 class="box-title"><?php echo $payroll['document_title']; ?></h3>
                                        </div><!-- /.box-header -->
                                        <div class="box-body">
                                            <ul class="list-group list-group-unbordered">
                                                <li class="list-group-item">
                                                    <b>Account No:</b> <a class="pull-right"><?php echo $payroll['bank_account_no']; ?></a>
                                                </li>
                                                <li class="list-group-item">
                                                    <b>Gross:</b> <a class="pull-right"><?php echo number_format($payroll['gross_salary'],2); ?></a>
                                                </li>
                                                <li class="list-group-item">
                                                    <b>Payable:</b> <a class="pull-right"><?php echo number_format($payroll['payable_salary'],2); ?></a>
                                                </li>
                                            </ul>
                                        </div><!-- /.box-body -->
                                        <div class="box-footer bg-green text-center">
                                            <a target="_blank" href="<?php echo $payroll['href_pay_slip']; ?>" class="bg-green cs-text-white">Print Slip</a>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div><!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>