<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary btnSave" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" id="primary_key" name="primary_key" value="<?php echo $employee_id; ?>" />
                                <ul class="nav nav-pills" style="border-bottom: 1px solid #3c8dbc;">
                                    <li class="active"><a href="#tabPersonal" data-toggle="tab"><?php echo $lang['personal_info']; ?></a></li>
                                    <li><a href="#tabBankAccount" data-toggle="tab"><?php echo $lang['bank_account']; ?></a></li>
                                    <li><a href="#tabFamilyMember" data-toggle="tab"><?php echo $lang['family_member']; ?></a></li>
                                    <li><a href="#tabQualification" data-toggle="tab"><?php echo $lang['qualification']; ?></a></li>
                                </ul>
                                <div class="tab-content" style="margin-top: 15px;">
                                    <div class="tab-pane active" id="tabPersonal">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <a href="javascript:void(0);" id="a_employee_image"  data-toggle="image" class="img-thumbnail" data-src_image="src_employee_image" data-src_input="file_employee_image" data-width="225" data-height="225">
                                                        <img alt="User profile picture" src="<?php echo $src_employee_image; ?>"  id="src_employee_image" alt="" title="" data-placeholder="<?php echo $no_image; ?>" class="img-responsive"/>
                                                    </a>
                                                    <input type="hidden" name="employee_image" value="<?php echo $employee_image; ?>" id="file_employee_image" />
                                                    <br />
                                                    <a class="btn btn-primary btn-xs" onclick="jQuery('#src_employee_image').attr('src', '<?php echo $no_image; ?>'); jQuery('#file_employee_image').attr('value', '');"><?php echo $lang['clear']; ?></a>
                                                    <br />&nbsp;
                                                </div>
                                            </div>
                                            <div class="col-md-9 //bg-gray">
                                                <h3 class="box-title bg-gray" style="border-bottom: 1px solid #000000">Personal Information</h3>
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['employee_code']; ?></label>
                                                            <input type="text" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" class="form-control" readonly/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['title_first_name']; ?></label>
                                                            <select class="form-control" id="title_first_name" name="title_first_name" >
                                                                <option value="">&nbsp;</option>
                                                                <option value="Shaikh" <?php echo $title_first_name=='Shaikh'? 'selected="true"':''?>>Shaikh</option>
                                                                <option value="Mulla"  <?php echo  $title_first_name=='Mulla'? 'selected="true"':''?>>Mulla</option>
                                                            </select>
                                                            <label for="title_first_name" class="error" style="display: none;">&nbsp;</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['first_name']; ?></label>
                                                            <input type="text" id="first_name" name="first_name" value="<?php echo $first_name; ?>" class="form-control"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['title_middle_name']; ?></label>
                                                            <select class="form-control" id="title_middle_name" name="title_middle_name" >
                                                                <option value="">&nbsp;</option>
                                                                <option value="Shaikh" <?php echo $title_middle_name=='Shaikh'? 'selected="true"':''?>>Shaikh</option>
                                                                <option value="Mulla"  <?php echo  $title_middle_name=='Mulla'? 'selected="true"':''?>>Mulla</option>
                                                            </select>
                                                            <label for="title_middle_name" class="error" style="display: none;">&nbsp;</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['middle_name']; ?></label>
                                                            <input type="text" id="middle_name" name="middle_name" value="<?php echo $middle_name; ?>" class="form-control"/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['surname']; ?></label>
                                                            <input type="text" id="surname" name="surname" value="<?php echo $surname; ?>" class="form-control"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-8">
                                                        <div class="form-group">
                                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['full_name']; ?></label>
                                                            <input type="text" id="full_name" name="full_name" value="<?php echo $full_name; ?>" class="form-control"/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['its_no']; ?></label>
                                                            <input type="text" id="its_no" name="its_no" value="<?php echo $its_no; ?>" class="form-control fPInteger" maxlength="8"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['dob']; ?></label>
                                                            <input type="text" id="dob" name="dob" value="<?php echo $dob; ?>" class="form-control" readonly/>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['gender']; ?></label>
                                                            <select class="form-control" id="gender" name="gender" >
                                                                <option value="">&nbsp;</option>
                                                                <option value="Male" <?php echo $gender=='Male'? 'selected="true"':''?>>Male</option>
                                                                <option value="Female"  <?php echo  $gender=='Female'? 'selected="true"':''?>>Female</option>
                                                            </select>
                                                            <label for="gender" class="error" style="display: none;">&nbsp;</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['marital_status']; ?></label>
                                                            <select class="form-control" id="marital_status" name="marital_status" >
                                                                <option value="">&nbsp;</option>
                                                                <option value="Single" <?php echo $marital_status=='Single'? 'selected="true"':''?>>Single</option>
                                                                <option value="Married"  <?php echo  $marital_status=='Married'? 'selected="true"':''?>>Married</option>
                                                            </select>
                                                            <label for="martial_status" class="error" style="display: none;">&nbsp;</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row //bg-aqua">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['mobile_no']; ?></label>
                                                    <input type="text" id="mobile_no" name="mobile_no" value="<?php echo $mobile_no; ?>" class="form-control fPhone"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['phone_no']; ?></label>
                                                    <input type="text" id="phone_no" name="phone_no" value="<?php echo $phone_no; ?>" class="form-control fPhone"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['email']; ?></label>
                                                    <input type="text" id="email" name="email" value="<?php echo $email; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['qualification']; ?></label>
                                                    <select class="form-control" id="qualification_id" name="qualification_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($qualifications as $qualification): ?>
                                                        <option value="<?php echo $qualification['qualification_id']; ?>" <?php echo ($qualification['qualification_id']==$qualification_id?'selected="true"':''); ?>><?php echo $qualification['qualification']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row //bg-aqua">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['employee_category']; ?></label>
                                                    <select class="form-control" id="employee_category_id" name="employee_category_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($employee_categories as $category): ?>
                                                        <option value="<?php echo $category['employee_category_id']; ?>" <?php echo ($category['employee_category_id']==$employee_category_id?'selected="true"':''); ?>><?php echo $category['employee_category']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['city']; ?></label>
                                                    <input type="text" id="city" name="city" value="<?php echo $city; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['area']; ?></label>
                                                    <input type="text" id="area" name="area" value="<?php echo $area; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['nationality']; ?></label>
                                                    <input type="text" id="nationality" name="nationality" value="<?php echo $nationality; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                        </div>
                                        <h3 class="box-title bg-gray" style="border-bottom: 1px solid #000000">Document Information</h3>
                                        <div class="row //bg-aqua">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['cnic_no']; ?></label>
                                                    <input type="text" id="cnic_no" name="cnic_no" value="<?php echo $cnic_no; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['cnic_expiry']; ?></label>
                                                    <input type="text" id="cnic_expiry" name="cnic_expiry" value="<?php echo $cnic_expiry; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['cnic_name']; ?></label>
                                                    <input type="text" id="cnic_name" name="cnic_name" value="<?php echo $cnic_name; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['cnic_address']; ?></label>
                                                    <input type="text" id="cnic_address" name="cnic_address" value="<?php echo $cnic_address; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row //bg-aqua-active">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['nicop_no']; ?></label>
                                                    <input type="text" id="nicop_no" name="nicop_no" value="<?php echo $nicop_no; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['nicop_expiry']; ?></label>
                                                    <input type="text" id="nicop_expiry" name="nicop_expiry" value="<?php echo $nicop_expiry; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['nicop_name']; ?></label>
                                                    <input type="text" id="nicop_name" name="nicop_name" value="<?php echo $nicop_name; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['nicop_address']; ?></label>
                                                    <input type="text" id="nicop_address" name="nicop_address" value="<?php echo $nicop_address; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row //bg-aqua-active">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['passport_no']; ?></label>
                                                    <input type="text" id="passport_no" name="passport_no" value="<?php echo $passport_no; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['passport_expiry']; ?></label>
                                                    <input type="text" id="passport_expiry" name="passport_expiry" value="<?php echo $passport_expiry; ?>" class="form-control dtpDate"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['passport_name']; ?></label>
                                                    <input type="text" id="passport_name" name="passport_name" value="<?php echo $passport_name; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['passport_address']; ?></label>
                                                    <input type="text" id="passport_address" name="passport_address" value="<?php echo $passport_address; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row //bg-aqua-active">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['eobi_no']; ?></label>
                                                    <input type="text" id="eobi_no" name="eobi_no" value="<?php echo $eobi_no; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['eobi_date']; ?></label>
                                                    <input type="text" id="eobi_date" name="eobi_date" value="<?php echo $eobi_date; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['eobi_sno']; ?></label>
                                                    <input type="text" id="eobi_sno" name="eobi_sno" value="<?php echo $eobi_sno; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['ntn_no']; ?></label>
                                                    <input type="text" id="ntn_no" name="ntn_no" value="<?php echo $ntn_no; ?>" class="form-control" readonly/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $grid_row_bank=0;?>
                                    <div class="tab-pane" id="tabBankAccount">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive">
                                                    <table id="tblBankAccount" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <td><?php echo $lang['company_name']; ?></td>
                                                            <td><?php echo $lang['department_name']; ?></td>
                                                            <td><?php echo $lang['bank_name']; ?></td>
                                                            <td><?php echo $lang['account_no']; ?></td>
                                                            <td><?php echo $lang['account_title']; ?></td>
                                                            <td><?php echo $lang['iban_no']; ?></td>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php foreach($employee_banks as $bank): ?>
                                                        <tr id="grid_row_bank_<?php echo $grid_row_bank; ?>" data-grid_row_bank_id="<?php echo $grid_row_bank; ?>">
                                                            <td><?php echo $bank['company_name']; ?></td>
                                                            <td><?php echo $bank['department_name']; ?></td>
                                                            <td><?php echo $bank['bank_name']; ?></td>
                                                            <td><?php echo $bank['bank_account']; ?></td>
                                                            <td><?php echo $bank['bank_title']; ?></td>
                                                            <td><?php echo $bank['bank_iban']; ?></td>
                                                        </tr>
                                                        <?php $grid_row_bank++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tabFamilyMember">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive">
                                                    <table id="tblEmployeeFamily" class="table table-bordered">
                                                        <thead>
                                                        <tr>
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnAddFamilyRow btn btn-xs btn-primary" title="Add"><i class="fa fa-plus"></i></button>
                                                            </td>
                                                            <td><?php echo $lang['relation']; ?></td>
                                                            <td><?php echo $lang['full_name']; ?></td>
                                                            <td><?php echo $lang['qualification']; ?></td>
                                                            <td><?php echo $lang['school']; ?></td>
                                                            <td><?php echo $lang['class']; ?></td>
                                                            <td><?php echo $lang['period_start_date']; ?></td>
                                                            <td><?php echo $lang['period_end_date']; ?></td>
                                                            <td><?php echo $lang['cnic_no']; ?></td>
                                                            <td><?php echo $lang['its_no']; ?></td>
                                                            <td><?php echo $lang['dob']; ?></td>
                                                            <td><?php echo $lang['mobile_no']; ?></td>
                                                            <td><?php echo $lang['email']; ?></td>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $grid_row_family=0;?>
                                                        <?php foreach($employee_families as $family): ?>
                                                        <tr id="grid_row_family_<?php echo $grid_row_family; ?>" data-grid_row_family_id="<?php echo $grid_row_family; ?>">
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnRemoveFamilyRow btn btn-xs btn-danger" title="Remove">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                                <input type="hidden" class="form-control" id="family_<?php echo $grid_row_family; ?>_employee_family_id" name="families[<?php echo $grid_row_family; ?>][employee_family_id]" value="<?php echo $family['employee_family_id']; ?>" />
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="family_<?php echo $grid_row_family; ?>_relation" name="families[<?php echo $grid_row_family; ?>][relation]">
                                                                    <option value="">&nbsp;</option>
                                                                    <option value="Self" <?php echo ($family['relation']=='Self'?'selected="true"':''); ?>>Self</option>
                                                                    <option value="Parent" <?php echo ($family['relation']=='Parent'?'selected="true"':''); ?>>Parent</option>
                                                                    <option value="Sibling" <?php echo ($family['relation']=='Sibling'?'selected="true"':''); ?>>Sibling</option>
                                                                    <option value="Spouse" <?php echo ($family['relation']=='Spouse'?'selected="true"':''); ?>>Spouse</option>
                                                                    <option value="Child" <?php echo ($family['relation']=='Child'?'selected="true"':''); ?>>Child</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" id="family_<?php echo $grid_row_family; ?>_full_name" name="families[<?php echo $grid_row_family; ?>][full_name]" value="<?php echo $family['full_name']; ?>" />
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="family_<?php echo $grid_row_family; ?>_qualification" name="families[<?php echo $grid_row_family; ?>][qualification_id]">
                                                                    <option value="">&nbsp;</option>
                                                                    <?php foreach($qualifications as $qualification): ?>
                                                                    <option value="<?php echo $qualification['qualification_id']; ?>" <?php echo ($qualification['qualification_id']==$family['qualification_id']?'selected="true"':''); ?>><?php echo $qualification['qualification']; ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="family_<?php echo $grid_row_family; ?>_school_id" name="families[<?php echo $grid_row_family; ?>][school_id]">
                                                                    <option value="">&nbsp;</option>
                                                                    <?php foreach($schools as $school): ?>
                                                                    <option value="<?php echo $school['school_id']; ?>" <?php echo ($school['school_id']==$family['school_id']?'selected="true"':''); ?>><?php echo $school['school_name']; ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="family_<?php echo $grid_row_family; ?>_calss_id" name="families[<?php echo $grid_row_family; ?>][class_id]">
                                                                    <option value="">&nbsp;</option>
                                                                    <?php foreach($classes as $class): ?>
                                                                    <option value="<?php echo $class['class_id']; ?>" <?php echo ($class['class_id']==$family['class_id']?'selected="true"':''); ?>><?php echo $class['class_name']; ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control dtpDate" id="family_<?php echo $grid_row_family; ?>_period_start_date" name="families[<?php echo $grid_row_family; ?>][period_start_date]" value="<?php echo ($family['period_start_date']!=''?stdDate($family['period_start_date']):''); ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control dtpDate" id="family_<?php echo $grid_row_family; ?>_period_end_date" name="families[<?php echo $grid_row_family; ?>][period_end_date]" value="<?php echo ($family['period_end_date']!=''?stdDate($family['period_end_date']):''); ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" id="family_<?php echo $grid_row_family; ?>_cnic_no" name="families[<?php echo $grid_row_family; ?>][cnic_no]" value="<?php echo $family['cnic_no']; ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" id="family_<?php echo $grid_row_family; ?>_its_no" name="families[<?php echo $grid_row_family; ?>][its_no]" value="<?php echo $family['its_no']; ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control dtpDate" id="family_<?php echo $grid_row_family; ?>_dob" name="families[<?php echo $grid_row_family; ?>][dob]" value="<?php echo ($family['dob']!=''?stdDate($family['dob']):''); ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" id="family_<?php echo $grid_row_family; ?>_mobile_no" name="families[<?php echo $grid_row_family; ?>][mobile_no]" value="<?php echo $family['mobile_no']; ?>" />
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" id="family_<?php echo $grid_row_family; ?>_email" name="families[<?php echo $grid_row_family; ?>][email]" value="<?php echo $family['email']; ?>" />
                                                            </td>
                                                        </tr>
                                                        <?php $grid_row_family++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tabQualification">
                                        <div class="table-responsive">
                                            <table id="tblEmployeeQualification" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <td style="width: 15px;">
                                                        <button type="button" data-toggle="tooltip" class="btnAddQualificationRow btn btn-xs btn-primary" title="Add"><i class="fa fa-plus"></i></button>
                                                    </td>
                                                    <td><?php echo $lang['qualification']; ?></td>
                                                    <td><?php echo $lang['major_subject']; ?></td>
                                                    <td><?php echo $lang['institute_type']; ?></td>
                                                    <td><?php echo $lang['institute_name']; ?></td>
                                                    <td><?php echo $lang['completion_date']; ?></td>
                                                    <td><?php echo $lang['grade_percent']; ?></td>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row_qualification=0;?>
                                                <?php foreach($employee_qualifications as $qualification): ?>
                                                <tr id="grid_row_qualification_<?php echo $grid_row_qualification; ?>" data-grid_row_qualification_id="<?php echo $grid_row_qualification; ?>">
                                                    <td style="width: 15px;">
                                                        <button type="button" data-toggle="tooltip" class="btnRemoveFamilyRow btn btn-xs btn-danger" title="Remove">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </td>
                                                    <td>
                                                        <select class="form-control" id="qualification_<?php echo $grid_row_qualification; ?>_qualification" name="qualifications[<?php echo $grid_row_qualification; ?>][qualification_id]">
                                                            <option value="">&nbsp;</option>
                                                            <?php foreach($qualifications as $row): ?>
                                                            <option value="<?php echo $row['qualification_id']; ?>" <?php echo ($row['qualification_id']==$qualification['qualification_id']?'selected="true"':''); ?>><?php echo $row['qualification']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="qualification_<?php echo $grid_row_qualification; ?>_major_subject" name="qualifications[<?php echo $grid_row_qualification; ?>][major_subject]" value="<?php echo $qualification['major_subject']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="qualification_<?php echo $grid_row_qualification; ?>_institute_type" name="qualifications[<?php echo $grid_row_qualification; ?>][institute_type]" value="<?php echo $qualification['institute_type']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="qualification_<?php echo $grid_row_qualification; ?>_institute_name" name="qualifications[<?php echo $grid_row_qualification; ?>][institute_name]" value="<?php echo $qualification['institute_name']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control dtpDate" id="qualification_<?php echo $grid_row_qualification; ?>_completion_date" name="qualifications[<?php echo $grid_row_qualification; ?>][completion_date]" value="<?php echo $qualification['completion_date']; ?>" />
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" id="qualification_<?php echo $grid_row_qualification; ?>_grade_percent" name="qualifications[<?php echo $grid_row_qualification; ?>][grade_percent]" value="<?php echo $qualification['grade_percent']; ?>" />
                                                    </td>
                                                </tr>
                                                <?php $grid_row_qualification++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <button type="button" class="btn btn-primary btnSave" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </button>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $banks = <?php echo json_encode($banks); ?>;
        var $qualifications = <?php echo json_encode($qualifications); ?>;
        var $schools = <?php echo json_encode($schools); ?>;
        var $classes = <?php echo json_encode($classes); ?>;
        var $grid_row_bank = <?php echo $grid_row_bank;?>;
        var $grid_row_family = <?php echo $grid_row_family;?>;
        var $grid_row_qualification = <?php echo $grid_row_qualification;?>;

        var $URLSaveAjax = '<?php echo $href_save_ajax; ?>';

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <script type="text/javascript" src="../employee/view/js/employee/employee_profile.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
    </div><!-- ./wrapper -->
    <?php echo $footer; ?>
</body>
</html>