<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary btnSave" onclick="submitDocument();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" id="primary_key" name="primary_key" value="<?php echo $employee_salary_id; ?>" />
                                <ul class="nav nav-pills" style="border-bottom: 1px solid #3c8dbc;">
                                    <li class="active"><a  href="#tabRegistration" data-toggle="tab"><?php echo $lang['registration']; ?></a></li>
                                    <li><a href="#tabSalary" data-toggle="tab"><?php echo $lang['salary']; ?></a></li>
                                </ul>
                                <div class="tab-content" style="margin-top: 15px;">
                                    <div class="tab-pane active" id="tabRegistration">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                    <select class="form-control" id="department_id" name="department_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($departments as $department): ?>
                                                        <option value="<?php echo $department['department_id']; ?>" <?php echo ($department['department_id']==$department_id?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="department_id" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['employee']; ?></label>
                                                    <select class="form-control" id="employee_id" name="employee_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($employees as $employee): ?>
                                                        <option value="<?php echo $employee['employee_id']; ?>" <?php echo ($employee['employee_id']==$employee_id?'selected="true"':''); ?>><?php echo $employee['employee_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="employee_id" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['wef_date']; ?></label>
                                                    <input type="text" id="wef_date" name="wef_date" value="<?php echo $wef_date; ?>" class="form-control dtpDate" />
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['basic_salary']; ?></label>
                                                    <input type="text" id="basic_salary" name="basic_salary" value="<?php echo $basic_salary; ?>" class="form-control fPDecimal" />
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <label>Allowances</label>
                                                <div class="table-responsive">
                                                    <table id="tblEmployeeAllowance" class="table table-bordered no-margin">
                                                        <thead>
                                                        <tr>
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnAddAllowance btn btn-xs btn-primary" title="Add"><i class="fa fa-plus"></i></button>
                                                            </td>
                                                            <td><?php echo $lang['allowance']; ?></td>
                                                            <td><?php echo $lang['allowance_type']; ?></td>
                                                            <td><?php echo $lang['allowance_value']; ?></td>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $grid_row_allowance=0;?>
                                                        <?php foreach($employee_allowances as $employee_allowance): ?>
                                                        <tr id="grid_row_allowance_<?php echo $grid_row_allowance; ?>" data-grid_row_allowance="<?php echo $grid_row_allowance; ?>">
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="employee_allowance_<?php echo $grid_row_allowance; ?>_allowance_id" name="employee_allowances[<?php echo $grid_row_allowance; ?>][allowance_id]">
                                                                    <?php foreach($allowances as $allowance): ?>
                                                                    <option value="<?php echo $allowance['allowance_id']; ?>" <?php echo ($allowance['allowance_id']==$employee_allowance['allowance_id']?'selected="true"':''); ?>><?php echo $allowance['allowance_name']; ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="employee_allowance_<?php echo $grid_row_allowance; ?>_allowance_type" name="employee_allowances[<?php echo $grid_row_allowance; ?>][allowance_type]">
                                                                    <option value="Fixed" <?php echo ($employee_allowance['allowance_type']=='Fixed'?'selected="true"':''); ?>>Fixed</option>
                                                                    <option value="Percent" <?php echo ($employee_allowance['allowance_type']=='Percent'?'selected="true"':''); ?>>Percent</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input class="form-control fPDecimal" id="employee_allowance_<?php echo $grid_row_allowance; ?>_allowance_value" name="employee_allowances[<?php echo $grid_row_allowance; ?>][allowance_value]" />
                                                            </td>
                                                        </tr>
                                                        <?php $grid_row_allowance++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <hr />
                                                <label>Deductions</label>
                                                <div class="table-responsive">
                                                    <table id="tblEmployeeDeduction" class="table table-bordered no-margin">
                                                        <thead>
                                                        <tr>
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnAddDeduction btn btn-xs btn-primary" title="Add"><i class="fa fa-plus"></i></button>
                                                            </td>
                                                            <td><?php echo $lang['deduction']; ?></td>
                                                            <td><?php echo $lang['deduction_type']; ?></td>
                                                            <td><?php echo $lang['deduction_value']; ?></td>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $grid_row_deduction=0;?>
                                                        <?php foreach($employee_deductions as $employee_deduction): ?>
                                                        <tr id="grid_row_deduction_<?php echo $grid_row_deduction; ?>" data-grid_row_deduction="<?php echo $grid_row_deduction; ?>">
                                                            <td style="width: 15px;">
                                                                <button type="button" data-toggle="tooltip" class="btnRemoveDeduction btn btn-xs btn-danger" title="Remove">
                                                                    <i class="fa fa-times"></i>
                                                                </button>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="employee_deduction_<?php echo $grid_row_deduction; ?>_deduction_id" name="employee_deductions[<?php echo $grid_row_deduction; ?>][deduction_id]">
                                                                    <?php foreach($deductions as $deduction): ?>
                                                                    <option value="<?php echo $deduction['deduction_id']; ?>" <?php echo ($deduction['deduction_id']==$employee_deduction['deduction_id']?'selected="true"':''); ?>><?php echo $deduction['deduction_name']; ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <select class="form-control" id="employee_deduction_<?php echo $grid_row_deduction; ?>_deduction_type" name="employee_deductions[<?php echo $grid_row_deduction; ?>][deduction_type]">
                                                                    <option value="Fixed" <?php echo ($employee_deduction['deduction_type']=='Fixed'?'selected="true"':''); ?>>Fixed</option>
                                                                    <option value="Percent" <?php echo ($employee_deduction['deduction_type']=='Percent'?'selected="true"':''); ?>>Percent</option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <input class="form-control fPDecimal" id="employee_deduction_<?php echo $grid_row_deduction; ?>_deduction_value" name="employee_deductions[<?php echo $grid_row_deduction; ?>][deduction_value]" />
                                                            </td>
                                                        </tr>
                                                        <?php $grid_row_deduction++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tabSalary">
                                        <div class="table-responsive">
                                            <table id="tblEmployeeFamily" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <td><?php echo $lang['wef_date']; ?></td>
                                                    <td><?php echo $lang['basic_salary']; ?></td>
                                                    <td><?php echo $lang['total_allowance']; ?></td>
                                                    <td><?php echo $lang['gross_salary']; ?></td>
                                                    <td><?php echo $lang['total_deduction']; ?></td>
                                                    <td><?php echo $lang['net_salary']; ?></td>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row_salary=0;?>
                                                <?php foreach($employee_salaries as $salary): ?>
                                                <tr id="grid_row_salary_<?php echo $grid_row_salary; ?>" data-grid_row_salary_id="<?php echo $grid_row_salary; ?>">
                                                    <td><?php echo $salary['wef_date']; ?></td>
                                                    <td><?php echo $salary['basic_salary']; ?></td>
                                                    <td><?php echo $salary['total_allowance']; ?></td>
                                                    <td><?php echo $salary['gross_salary']; ?></td>
                                                    <td><?php echo $salary['total_deduction']; ?></td>
                                                    <td><?php echo $salary['net_salary']; ?></td>
                                                </tr>
                                                <?php $grid_row_salary++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <button type="button" class="btn btn-primary btnSave" onclick="submitDocument();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </button>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLSaveAjax = '<?php echo $href_save_ajax; ?>';
        var $URLGetEmployee = '<?php echo $href_get_employee; ?>';
        var $grid_row_allowance = '<?php echo $grid_row_allowance; ?>';
        var $grid_row_deduction = '<?php echo $grid_row_deduction; ?>';
        var $allowances = <?php echo json_encode($allowances); ?>;
        var $deductions = <?php echo json_encode($deductions); ?>;

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <script type="text/javascript" src="../admin/view/js/employee/employee_salary.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>