<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
<?php echo $page_header; ?>
<?php echo $column_left; ?>
<div class="content-wrapper">
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo $lang['heading_title']; ?></h1>
    <div class="row">
        <div class="col-sm-6">
            <ol class="breadcrumb">
                <?php foreach($breadcrumbs as $breadcrumb): ?>
                <li>
                    <a href="<?php echo $breadcrumb['href']; ?>">
                        <i class="<?php echo $breadcrumb['class']; ?>"></i>
                        <?php echo $breadcrumb['text']; ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ol>
        </div>
        <div class="col-sm-6">
            <div class="pull-right">
                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                    <i class="fa fa-undo"></i>
                    &nbsp;<?php echo $lang['cancel']; ?>
                </a>
                <?php if($approved_status!='Approved'): ?>
                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                    <i class="fa fa-floppy-o"></i>
                    &nbsp;<?php echo $lang['save']; ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-sm-12">
            <div class="box">
                <div class="box-header">
                    <?php if ($error_warning) { ?>
                    <div class="alert alert-danger alert-dismissable">
                        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                        <?php echo $error_warning; ?>
                    </div>
                    <?php } ?>
                    <?php  if ($success) { ?>
                    <div class="alert alert-success alert-dismissable">
                        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                        <?php echo $success; ?>
                    </div>
                    <?php  } ?>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                        <input type="hidden" name="allowance_type" value="Scholarship" />
                        <input type="hidden" id="company_id" name="company_id" value="<?php echo $company_id; ?>" />
                        <input type="hidden" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" />
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['receipt_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document']; ?></label>
                                            <?php if($href_document_file != ''): ?>
                                            <a target="_blank" class="pull-right" href="<?php echo $href_document_file; ?>" title="Document"><?php echo $file_name; ?></a>
                                            <?php endif; ?>
                                            <input type="file" class="form-control" id="document" name="document" value="" accept="text/plain"  />
                                            <input type="hidden" class="form-control" id="file_name" name="file_name" value="<?php echo $file_name; ?>" />
                                            <input type="hidden" class="form-control" id="file_directory" name="file_directory" value="<?php echo $file_directory; ?>" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-8">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select id="employee_registration_id" name="employee_registration_id" class="form-control">
                                                <option data-registration_code="" data-company_id="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option data-employee_code="<?php echo $employee['employee_code']?>" data-employee_id="<?php echo $employee['employee_id']?>" data-registration_code="<?php echo $employee['registration_code']?>" data-company_id="<?php echo $employee['company_id']?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?> value="<?php echo $employee['employee_registration_id']; ?>"><?php echo $employee['company_name'].' - '.$employee['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['total_amount']; ?></label>
                                            <input type="text" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" class="form-control text-right" readonly/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblSpecialAllowance" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th style="width: 15px;"><a class="btnAddAllowance btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></th>
                                                    <th class="text-center"><?php echo $lang['allowance_for']; ?></th>
                                                    <th class="text-center"><?php echo $lang['amount']; ?></th>
                                                    <th class="text-center"><?php echo $lang['remarks']; ?></th>
                                                    <th class="text-center"><?php echo $lang['receipt_date']; ?></th>
                                                    <th class="text-center"><?php echo $lang['receipt_no']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $grid_row_allowance=0; ?>
                                                <?php foreach($allowance_details as $detail): ?>
                                                <tr id="grid_row_id_<?php echo $grid_row_allowance; ?>" data-row_id="<?php echo $grid_row_allowance; ?>">
                                                    <td style="width: 15px;"><a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>
                                                    <td>
                                                        <input type="hidden" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_allowance_for" name="details[<?php echo $grid_row_allowance; ?>][allowance_for]" value="<?php echo $detail['allowance_for']; ?>" />
                                                        <select onchange="updateRelation('<?php echo $grid_row_allowance; ?>');" class="form-control" id="detail_<?php echo $grid_row_allowance; ?>_employee_family_id" name="details[<?php echo $grid_row_allowance; ?>][employee_family_id]" >
                                                            <?php foreach($families as $family): ?>
                                                            <option value="<?php echo $family['employee_family_id']; ?>" <?php echo ($detail['employee_family_id']==$family['employee_family_id']?'selected=true':'');?>><?php echo $family['full_name']; ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td><input onchange="calculateTotal();" type="text" class="form-control fPDecimal" id="detail_<?php echo $grid_row_allowance; ?>_amount" name="details[<?php echo $grid_row_allowance; ?>][amount]" value="<?php echo $detail['amount']; ?> " /></td>
                                                    <td><input type="text" class="form-control " id="detail_<?php echo $grid_row_allowance; ?>_remarks" name="details[<?php echo $grid_row_allowance; ?>][remarks]" value="<?php echo $detail['remarks']; ?> " /></td>
                                                    <td><input type="text" class="form-control dtpDate" id="detail_<?php echo $grid_row_allowance; ?>_receipt_date" name="details[<?php echo $grid_row_allowance; ?>][receipt_date]" value="<?php echo $detail['receipt_date']; ?> " /></td>
                                                    <td><input type="text" class="form-control " id="detail_<?php echo $grid_row_allowance; ?>_receipt_no" name="details[<?php echo $grid_row_allowance; ?>][receipt_no]" value="<?php echo $detail['receipt_no']; ?> " /></td>
                                                </tr>
                                                <?php $grid_row_allowance++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <label><?php echo $lang['scholarship_policy']; ?></label>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table id="tblPolicy" class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th>Allowance For</th>
                                                    <th>Scholarship On</th>
                                                    <th>Scholarship Value</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($scholarship_policies as $policy): ?>
                                                <tr>
                                                    <td><?php echo $policy['relation']; ?></td>
                                                    <td><?php echo $policy['scholarship_on']; ?></td>
                                                    <td><?php echo $policy['scholarship_value']; ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <label>Previous Approved.</label>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table id="tblApproved" class="table table-stripped">
                                                <thead>
                                                <tr>
                                                    <th class="text-center"><?php echo $lang['date']; ?></th>
                                                    <th class="text-center"><?php echo $lang['voucher_no']; ?></th>
                                                    <th class="text-center"><?php echo $lang['total_amount']; ?></th>
                                                    <th class="text-center"><?php echo $lang['approved_amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($approved_scholarships as $scholarship): ?>
                                                <tr>
                                                    <td class="text-center"><?php echo $scholarship['document_date']; ?></td>
                                                    <td class="text-center"><?php echo $scholarship['document_identity']; ?></td>
                                                    <td class="text-center"><?php echo $scholarship['total_amount']; ?></td>
                                                    <td class="text-center"><?php echo $scholarship['approved_amount']; ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                        <i class="fa fa-undo"></i>
                        &nbsp;<?php echo $lang['cancel']; ?>
                    </a>
                    <?php if($approved_status!='Approved'): ?>
                    <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                        <i class="fa fa-floppy-o"></i>
                        &nbsp;<?php echo $lang['save']; ?>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</section>
</div>
<script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
<script type="text/javascript" src="../employee/view/js/employee/employee_scholarship.js"></script>
<script>
    jQuery('#form').validate(<?php echo $strValidation; ?>);

    var $employees = <?php echo json_encode($employees); ?>;
    var $family_exists = <?php echo $family_exists; ?>;
    var $families = <?php echo json_encode($families); ?>;
    var $grid_row_allowance = <?php echo $grid_row_allowance; ?>;
    var $URLGetPolicy = '<?php echo $href_get_policy; ?>';

</script>

<?php echo $page_footer; ?>
<?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>